#include <scheme/test_reconstruction.hpp>

#include <scheme/PolynomialReconstruction.hpp>
#include <utils/Timer.hpp>

void
test_reconstruction(std::shared_ptr<const DiscreteFunctionVariant> df, size_t degree, size_t number)
{
  if (degree == 1) {
    PolynomialReconstructionDescriptor descriptor{IntegrationMethodType::cell_center, degree};
    PolynomialReconstruction rec_builder{descriptor};

    Timer t;

    for (size_t i = 0; i < number; ++i) {
      auto rec = rec_builder.build(df);
    }

    std::cout << "*** Elapsed time for " << number << " cell center reconstructions: " << t.seconds() << "s ***\n";
  }

  {
    PolynomialReconstructionDescriptor descriptor{IntegrationMethodType::boundary, degree};
    PolynomialReconstruction rec_builder{descriptor};

    Timer t;

    for (size_t i = 0; i < number; ++i) {
      auto rec = rec_builder.build(df);
    }

    std::cout << "*** Elapsed time for " << number << " boundary reconstructions: " << t.seconds() << "s ***\n";
  }
  {
    PolynomialReconstructionDescriptor descriptor{IntegrationMethodType::element, degree};
    PolynomialReconstruction rec_builder{descriptor};

    Timer t;

    for (size_t i = 0; i < number; ++i) {
      auto rec = rec_builder.build(df);
    }

    std::cout << "*** Elapsed time for " << number << " element reconstructions: " << t.seconds() << "s ***\n";
  }
}
