#ifndef INTEGRATE_CELL_VALUE_HPP
#define INTEGRATE_CELL_VALUE_HPP

#include <analysis/IQuadratureDescriptor.hpp>
#include <language/utils/IntegrateOnCells.hpp>
#include <mesh/ItemType.hpp>
#include <mesh/ItemValue.hpp>
#include <mesh/Mesh.hpp>

template <typename T>
class IntegrateCellValue;
template <typename OutputType, typename InputType>
class IntegrateCellValue<OutputType(InputType)>
{
 public:
  template <typename MeshType>
  PUGS_INLINE static CellValue<OutputType>
  integrate(const FunctionSymbolId& function_symbol_id,
            const IQuadratureDescriptor& quadrature_descriptor,
            const MeshType& mesh)
  {
    CellValue<OutputType> value(mesh.connectivity());
    IntegrateOnCells<OutputType(const InputType)>::template integrateTo<MeshType>(function_symbol_id,
                                                                                  quadrature_descriptor, mesh, value);

    return value;
  }

  template <typename MeshType>
  PUGS_INLINE static Array<OutputType>
  integrate(const FunctionSymbolId& function_symbol_id,
            const IQuadratureDescriptor& quadrature_descriptor,
            const MeshType& mesh,
            const Array<const CellId>& list_of_cells)
  {
    return IntegrateOnCells<OutputType(const InputType)>::integrate(function_symbol_id, quadrature_descriptor, mesh,
                                                                    list_of_cells);
  }

  template <typename MeshType>
  PUGS_INLINE static Array<OutputType>
  integrate(const FunctionSymbolId& function_symbol_id,
            const IQuadratureDescriptor& quadrature_descriptor,
            const MeshType& mesh,
            const Array<CellId>& list_of_cells)
  {
    return IntegrateOnCells<OutputType(const InputType)>::integrate(function_symbol_id, quadrature_descriptor, mesh,
                                                                    Array<const CellId>{list_of_cells});
  }
};

#endif   // INTEGRATE_CELL_VALUE_HPP
