#ifndef SCALAR_HYBRID_SCHEME_HPP
#define SCALAR_HYBRID_SCHEME_HPP

#include <algebra/CRSMatrix.hpp>
#include <algebra/CRSMatrixDescriptor.hpp>
#include <algebra/LeastSquareSolver.hpp>
#include <algebra/LinearSolver.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <language/utils/InterpolateItemValue.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/DualConnectivityManager.hpp>
#include <mesh/DualMeshManager.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/MeshFaceBoundary.hpp>
#include <mesh/MeshNodeBoundary.hpp>
#include <mesh/PrimalToDiamondDualConnectivityDataMapper.hpp>
#include <mesh/PrimalToMedianDualConnectivityDataMapper.hpp>
#include <mesh/SubItemValuePerItem.hpp>
#include <scheme/DirichletBoundaryConditionDescriptor.hpp>
#include <scheme/FourierBoundaryConditionDescriptor.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/NeumannBoundaryConditionDescriptor.hpp>
#include <scheme/SymmetryBoundaryConditionDescriptor.hpp>

class ScalarHybridSchemeHandler
{
 private:
  class IScalarHybridScheme;

  template <size_t Dimension>
  class ScalarHybridScheme;

  template <size_t Dimension>
  class InterpolationWeightsManager;

 public:
  std::unique_ptr<IScalarHybridScheme> m_scheme;

  // std::shared_ptr<const IDiscreteFunction> solution() const;
  std::tuple<std::shared_ptr<const IDiscreteFunction>, std::shared_ptr<const IDiscreteFunction>> solution() const;

  ScalarHybridSchemeHandler(
    const std::shared_ptr<const IDiscreteFunction>& cell_k,
    const std::shared_ptr<const IDiscreteFunction>& f,
    const std::shared_ptr<const IDiscreteFunction>& f_prec,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_prev_descriptor_list,
    const std::shared_ptr<const IDiscreteFunction>& P,
    const double& dt,
    const double& cn_coeff,
    const double& lambda);

  ~ScalarHybridSchemeHandler();
};

#endif   // SCALAR_NODAL_SCHEME_HPP
