#ifndef AST_PRINTER_HPP
#define AST_PRINTER_HPP

#include <ASTNode.hpp>

namespace language
{
class ASTPrinter
{
 public:
  enum class Format
  {
    raw,
    pretty
  };

 private:
  const Node& m_node;

  mutable std::string prefix;
  mutable std::vector<int> last_prefix_size;

  std::string T_junction;
  std::string L_junction;

  std::string pipe_space;
  std::string space_space;

  void _print(std::ostream& os, const Node& node) const;

  template <typename NodeVector>
  void _print(std::ostream& os, const NodeVector& node_list) const;

 public:
  friend std::ostream& operator<<(std::ostream& os, const ASTPrinter& ast_printer);

  ASTPrinter(const Node& node, Format format = Format::pretty);

  ASTPrinter(const ASTPrinter&) = delete;

  ASTPrinter(ASTPrinter&&) = delete;

  ~ASTPrinter() = default;
};
}   // namespace language
#endif   // AST_PRINTER_HPP
