#ifndef LINEAR_SOLVER_HPP
#define LINEAR_SOLVER_HPP

#include <algebra/CRSMatrix.hpp>
#include <algebra/DenseMatrix.hpp>
#include <algebra/LinearSolverOptions.hpp>
#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <utils/Exceptions.hpp>

class LinearSolver
{
 private:
  struct Internals;

  const LinearSolverOptions m_options;

 public:
  bool hasLibrary(LSLibrary library) const;
  void checkOptions(const LinearSolverOptions& options) const;

  template <size_t N>
  void
  solveLocalSystem(const TinyMatrix<N>& A, TinyVector<N>& x, const TinyVector<N>& b)
  {
    DenseMatrix A_dense{A};
    Vector<double> x_vector{N};
    Vector<double> b_vector{N};
    for (size_t i = 0; i < N; ++i) {
      x_vector[i] = x[i];
      b_vector[i] = b[i];
    }

    this->solveLocalSystem(A_dense, x_vector, b_vector);

    for (size_t i = 0; i < N; ++i) {
      x[i] = x_vector[i];
    }
  }

  void solveLocalSystem(const CRSMatrix<double, int>& A, Vector<double>& x, const Vector<const double>& b);
  void solveLocalSystem(const DenseMatrix<double>& A, Vector<double>& x, const Vector<const double>& b);

  LinearSolver();
  LinearSolver(const LinearSolverOptions& options);
};

#endif   // LINEAR_SOLVER_HPP
