#include <ASTNodeValueBuilder.hpp>

#include <PEGGrammar.hpp>
#include <PugsAssert.hpp>

#include <EscapedString.hpp>

void
ASTNodeValueBuilder::_buildNodeValue(ASTNode& n)
{
  if (n.is<language::bloc>()) {
    if (!n.children.empty()) {
      for (auto& child : n.children) {
        this->_buildNodeValue(*child);
      }
    }
    n.m_data_type = ASTNodeDataType::void_t;
  } else {
    for (auto& child : n.children) {
      this->_buildNodeValue(*child);
    }

    if (n.has_content()) {
      if (n.is<language::real>()) {
        std::stringstream ss(n.string());
        double v;
        ss >> v;
        n.m_value = v;
      } else if (n.is<language::integer>()) {
        std::stringstream ss(n.string());
        int64_t v;
        ss >> v;
        n.m_value = v;
      } else if (n.is<language::literal>()) {
        n.m_value = unescapeString(n.string());
      } else if (n.is<language::for_test>()) {
        // if AST contains a for_test statement, it means that no test were
        // given to the for-loop, so its value is always true
        n.m_value = true;
      } else if (n.is<language::true_kw>()) {
        n.m_value = true;
      } else if (n.is<language::false_kw>()) {
        n.m_value = false;
      }
    }
  }
}

ASTNodeValueBuilder::ASTNodeValueBuilder(ASTNode& n)
{
  Assert(n.is_root());
  n.m_data_type = ASTNodeDataType::void_t;
  this->_buildNodeValue(n);
  std::cout << " - build node data types\n";
}
