#ifndef AST_NODE_DATA_TYPE_HPP
#define AST_NODE_DATA_TYPE_HPP

#include <limits>
#include <string>

enum class ASTNodeDataType : int32_t
{
  undefined_t    = -1,
  bool_t         = 0,
  unsigned_int_t = 1,
  int_t          = 2,
  double_t       = 3,
  string_t       = 5,
  typename_t     = 10,
  void_t         = std::numeric_limits<int32_t>::max()
};

std::string dataTypeName(const ASTNodeDataType& data_type);

ASTNodeDataType dataTypePromotion(const ASTNodeDataType& data_type_1, const ASTNodeDataType& data_type_2);

#endif   // AST_NODE_DATA_TYPE_HPP
