#ifndef AST_NODE_HPP
#define AST_NODE_HPP

#include <PugsAssert.hpp>
#include <PugsMacros.hpp>

#include <ASTNodeDataType.hpp>
#include <ASTNodeDataVariant.hpp>

#include <pegtl/contrib/parse_tree.hpp>

using namespace TAO_PEGTL_NAMESPACE;

struct ExecUntilBreakOrContinue
{
  enum class JumpType
  {
    no_jump,
    break_jump,
    continue_jump
  };

 private:
  JumpType m_jump_type{JumpType::no_jump};
  bool m_exec{true};

 public:
  PUGS_INLINE
  bool
  exec() const
  {
    return m_exec;
  }

  PUGS_INLINE
  JumpType
  jumpType() const
  {
    return m_jump_type;
  }

  ExecUntilBreakOrContinue& operator=(const ExecUntilBreakOrContinue&) = delete;
  ExecUntilBreakOrContinue& operator=(ExecUntilBreakOrContinue&&) = default;

  ExecUntilBreakOrContinue() = default;

  constexpr ExecUntilBreakOrContinue(const JumpType& jump_type)
    : m_jump_type(jump_type), m_exec((jump_type == JumpType::no_jump))
  {
    ;
  }
};

class INodeProcessor
{
 public:
  virtual void execute(ExecUntilBreakOrContinue& exec_policy) = 0;

  INodeProcessor(const INodeProcessor& node) = delete;

  INodeProcessor() {}

  virtual ~INodeProcessor() {}
};

class SymbolTable;

struct ASTNode : public parse_tree::basic_node<ASTNode>
{
  std::shared_ptr<SymbolTable> m_symbol_table;
  std::unique_ptr<INodeProcessor> m_node_processor;

  PUGS_INLINE
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    Assert(static_cast<bool>(m_node_processor));
    if (exec_policy.exec()) {
      m_node_processor->execute(exec_policy);
    }
  }

  ASTNodeDataType m_data_type{ASTNodeDataType::undefined_t};
  ASTNodeDataVariant m_value;
};

#endif   // AST_NODE_HPP
