#include <language/modules/SocketModule.hpp>

#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <utils/Socket.hpp>

SocketModule::SocketModule()
{
  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const Socket>>);

  this->_addBuiltinFunction("createSocketServer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(const uint64_t&)>>(

                              [](const uint64_t& port_number) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(createSocketServer(port_number));
                              }

                              ));

  this->_addBuiltinFunction("acceptSocketClient",
                            std::make_shared<
                              BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(std::shared_ptr<const Socket>)>>(

                              [](std::shared_ptr<const Socket> server_socket) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(acceptSocketClient(*server_socket));
                              }

                              ));

  this->_addBuiltinFunction("connectSocketServer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(const std::string&,
                                                                                                   const uint64_t&)>>(

                              [](const std::string& hostname,
                                 const uint64_t& port_number) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(connectSocketServer(hostname, port_number));
                              }

                              ));
}

void
SocketModule::registerOperators() const
{}
