#ifndef REF_ITEM_LIST_HPP
#define REF_ITEM_LIST_HPP

#include <utils/Array.hpp>

#include <mesh/ItemId.hpp>
#include <mesh/RefId.hpp>

template <ItemType item_type>
class RefItemList
{
 public:
  using ItemId = ItemIdT<item_type>;

 private:
  RefId m_ref_id;
  Array<const ItemId> m_item_id_list;
  bool m_is_boundary;

 public:
  const RefId&
  refId() const
  {
    return m_ref_id;
  }

  const Array<const ItemId>&
  list() const
  {
    return m_item_id_list;
  }

  bool
  isBoundary() const
  {
    return m_is_boundary;
  }

  RefItemList(const RefId& ref_id, const Array<const ItemId>& item_id_list, bool is_boundary)
    : m_ref_id{ref_id}, m_item_id_list{item_id_list}, m_is_boundary{is_boundary}
  {
    ;
  }

  RefItemList& operator=(const RefItemList&) = default;
  RefItemList& operator=(RefItemList&&) = default;

  RefItemList()                   = default;
  RefItemList(const RefItemList&) = default;
  ~RefItemList()                  = default;
};

using RefNodeList = RefItemList<ItemType::node>;
using RefEdgeList = RefItemList<ItemType::edge>;
using RefFaceList = RefItemList<ItemType::face>;
using RefCellList = RefItemList<ItemType::cell>;

#endif   // REF_ITEM_LIST_HPP
