#ifndef IMPLICIT_MESH_SMOOTHER_HPP
#define IMPLICIT_MESH_SMOOTHER_HPP
#include <algebra/CRSMatrix.hpp>
#include <algebra/CRSMatrixDescriptor.hpp>
#include <algebra/LinearSolver.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <language/utils/InterpolateItemValue.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/DualConnectivityManager.hpp>
#include <mesh/DualMeshManager.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/MeshFaceBoundary.hpp>
#include <mesh/MeshNodeBoundary.hpp>
#include <mesh/PrimalToDiamondDualConnectivityDataMapper.hpp>
#include <mesh/SubItemValuePerItem.hpp>
#include <scheme/DirichletBoundaryConditionDescriptor.hpp>
#include <scheme/FourierBoundaryConditionDescriptor.hpp>
#include <scheme/NeumannBoundaryConditionDescriptor.hpp>
#include <scheme/SymmetryBoundaryConditionDescriptor.hpp>

#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <vector>

class FunctionSymbolId;
class IZoneDescriptor;
class DiscreteFunctionVariant;

class ImplicitMeshSmootherHandler
{
 private:
  template <size_t Dimension>
  class ImplicitMeshSmoother;

 public:
  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const;
  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const FunctionSymbolId& function_symbol_id) const;
  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::vector<std::shared_ptr<const DiscreteFunctionVariant>>& discrete_function_variant_list) const;

  // std::shared_ptr<const IMesh> getSmoothedMesh(
  //   const std::shared_ptr<const IMesh>& mesh,
  //   const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
  //   const FunctionSymbolId& function_symbol_id) const;

  // std::shared_ptr<const IMesh> getSmoothedMesh(
  //   const std::shared_ptr<const IMesh>& mesh,
  //   const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
  //   const std::vector<std::shared_ptr<const IZoneDescriptor>>& smoothing_zone_list) const;

  // std::shared_ptr<const IMesh> getSmoothedMesh(
  //   const std::shared_ptr<const IMesh>& mesh,
  //   const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
  //   const std::vector<std::shared_ptr<const DiscreteFunctionVariant>>& smoothing_zone_list) const;

  ImplicitMeshSmootherHandler()                              = default;
  ImplicitMeshSmootherHandler(ImplicitMeshSmootherHandler&&) = default;
  ~ImplicitMeshSmootherHandler()                             = default;
};

#endif   // IMPLICIT_MESH_SMOOTHER_HPP
