#ifndef I_MESH_HPP
#define I_MESH_HPP

#include <cstddef>
#include <iostream>

class IMesh
{
 protected:
  virtual std::ostream& _write(std::ostream&) const = 0;

 public:
  virtual size_t dimension() const = 0;

  friend std::ostream&
  operator<<(std::ostream& os, const IMesh& mesh)
  {
    return mesh._write(os);
  }

  IMesh(const IMesh&) = delete;
  IMesh(IMesh&&)      = delete;

  IMesh() = default;
  virtual ~IMesh();
};

#endif   // I_MESH_HPP
