#ifndef AFFECTATION_PROCESSOR_BUILDER_HPP
#define AFFECTATION_PROCESSOR_BUILDER_HPP

#include <algebra/TinyVector.hpp>
#include <language/PEGGrammar.hpp>
#include <language/node_processor/AffectationProcessor.hpp>
#include <language/utils/IAffectationProcessorBuilder.hpp>

#include <type_traits>

template <typename OperatorT, typename ValueT, typename DataT>
class AffectationProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    if constexpr (std::is_same_v<ValueT, TinyVector<1>> and std::is_same_v<DataT, int64_t> and
                  std::is_same_v<OperatorT, language::eq_op>) {
      // Special treatment for the case 0 -> R^1
      if ((node.children[1]->is_type<language::integer>()) and (std::stoi(node.children[1]->string()) == 0)) {
        return std::make_unique<AffectationFromZeroProcessor<ValueT>>(node);
      } else {
        return std::make_unique<AffectationProcessor<OperatorT, ValueT, DataT>>(node);
      }
    } else {
      return std::make_unique<AffectationProcessor<OperatorT, ValueT, DataT>>(node);
    }
  }
};

template <typename ValueT>
class AffectationToTupleProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationToTupleProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    return std::make_unique<AffectationToTupleProcessor<ValueT>>(node);
  }
};

template <typename ValueT>
class AffectationToTupleFromListProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationToTupleFromListProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    return std::make_unique<AffectationToTupleFromListProcessor<ValueT>>(node);
  }
};

template <typename OperatorT, typename ValueT>
class AffectationToTinyVectorFromListProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationToTinyVectorFromListProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    return std::make_unique<AffectationToTinyVectorFromListProcessor<OperatorT, ValueT>>(node);
  }
};

template <typename OperatorT, typename ValueT>
class AffectationToTinyMatrixFromListProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationToTinyMatrixFromListProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    return std::make_unique<AffectationToTinyMatrixFromListProcessor<OperatorT, ValueT>>(node);
  }
};

template <typename OperatorT, typename ValueT>
class AffectationFromZeroProcessorBuilder final : public IAffectationProcessorBuilder
{
 public:
  AffectationFromZeroProcessorBuilder() = default;
  std::unique_ptr<INodeProcessor>
  getNodeProcessor(ASTNode& node) const
  {
    if (std::stoi(node.children[1]->string()) == 0) {
      return std::make_unique<AffectationFromZeroProcessor<ValueT>>(node);
    } else {
      throw ParseError("invalid integral value (0 is the solely valid value)", std::vector{node.children[1]->begin()});
    }
  }
};

#endif   // AFFECTATION_PROCESSOR_BUILDER_HPP
