#include <language/modules/CoreModule.hpp>

#include <language/modules/CoreModule.hpp>
#include <language/modules/ModuleRepository.hpp>
#include <language/utils/ASTExecutionInfo.hpp>
#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <utils/PugsUtils.hpp>

CoreModule::CoreModule() : BuiltinModule(true)
{
  this->_addBuiltinFunction("getPugsVersion", std::make_shared<BuiltinFunctionEmbedder<std::string(void)>>(

                                                []() -> std::string { return pugsVersion(); }

                                                ));

  this->_addBuiltinFunction("getPugsBuildInfo", std::make_shared<BuiltinFunctionEmbedder<std::string(void)>>(

                                                  []() -> std::string { return pugsBuildInfo(); }

                                                  ));

  this->_addBuiltinFunction("getAvailableModules", std::make_shared<BuiltinFunctionEmbedder<std::string()>>(

                                                     []() -> std::string {
                                                       const ModuleRepository& repository =
                                                         ASTExecutionInfo::current().moduleRepository();

                                                       return repository.getAvailableModules();
                                                     }

                                                     ));

  this->_addBuiltinFunction("getModuleInfo", std::make_shared<BuiltinFunctionEmbedder<std::string(const std::string&)>>(

                                               [](const std::string& module_name) -> std::string {
                                                 const ModuleRepository& repository =
                                                   ASTExecutionInfo::current().moduleRepository();

                                                 return repository.getModuleInfo(module_name);
                                               }

                                               ));
}
