#ifndef PASTIS_UTILS_HPP
#define PASTIS_UTILS_HPP

#include <Kokkos_Core.hpp>
#include <PastisMacros.hpp>

#include <functional>
#include <string>

template <typename FunctionType>
PASTIS_FORCEINLINE
void parallel_for(const size_t& size,
                  const FunctionType& lambda,
                  const std::string& label = "")
{
  Kokkos::parallel_for(size, lambda, label);
}

template <typename ArrayType, typename ReturnType>
PASTIS_FORCEINLINE
void parallel_reduce(const size_t& size,
                     const ArrayType& array,
                     ReturnType& value,
                     const std::string& label = "")
{
  Kokkos::parallel_reduce(label, size, array, value);
}

std::string initialize(int& argc, char* argv[]);

void finalize();

#endif // PASTIS_UTILS_HPP
