#ifndef PASTIS_OSTREAM_HPP
#define PASTIS_OSTREAM_HPP

#include <PastisMacros.hpp>
#include <iostream>
#include <sstream>

extern std::stringstream null_stream;

class PastisOStream
{
 private:
  std::ostream* m_os = nullptr;

 public:
  PASTIS_INLINE
  std::ostream& operator()()
  {
    return *m_os;
  }

  void setOutput(std::ostream& os)
  {
    m_os = &os;
  }

  PastisOStream(std::ostream& os)
      : m_os(&os)
  {
    ;
  }

  PastisOStream& operator=(const PastisOStream&) = delete;
  PastisOStream& operator=(PastisOStream&&) = delete;
  PastisOStream(const PastisOStream&) = delete;
  PastisOStream(PastisOStream&&) = delete;

  ~PastisOStream() = default;
};

extern PastisOStream pout;
extern PastisOStream perr;
extern const PastisOStream _null_stream_initializer;

#endif // PASTIS_OSTREAM_HPP
