#ifndef IMODULE_HPP
#define IMODULE_HPP

#include <memory>
#include <string>
#include <string_view>
#include <unordered_map>

class IBuiltinFunctionEmbedder;
class TypeDescriptor;

class IModule
{
 public:
  using NameBuiltinFunctionMap = std::unordered_map<std::string, std::shared_ptr<IBuiltinFunctionEmbedder>>;
  using NameTypeMap            = std::unordered_map<std::string, std::shared_ptr<TypeDescriptor>>;

  IModule()          = default;
  IModule(IModule&&) = default;
  IModule& operator=(IModule&&) = default;

  virtual bool isMandatory() const = 0;

  virtual const NameBuiltinFunctionMap& getNameBuiltinFunctionMap() const = 0;

  virtual const NameTypeMap& getNameTypeMap() const = 0;

  virtual std::string_view name() const = 0;

  virtual ~IModule() = default;
};

#endif   // IMODULE_HPP
