#include <ConnectivityComputer.hpp>
#include <map>

void ConnectivityComputer::
computeInverseConnectivityMatrix(const ConnectivityMatrix& item_to_child_item_matrix,
                                 ConnectivityMatrix& child_item_to_item_matrix) const
{
  std::map<unsigned int, std::vector<unsigned int>> child_item_to_item_vector_map;
  const size_t& number_of_items = item_to_child_item_matrix.numRows();

  for (unsigned int j=0; j<number_of_items; ++j) {
    const auto& item_to_child_items = item_to_child_item_matrix.rowConst(j);
    for (unsigned int r=0; r<item_to_child_items.length; ++r) {
      child_item_to_item_vector_map[item_to_child_items(r)].push_back(j);
    }
  }

  {
    size_t i=0;
    for (const auto& [child_item_id, item_vector] : child_item_to_item_vector_map) {
      if (child_item_id != i) {
        std::cerr << "sparse item numerotation NIY\n";
        std::exit(0);
      }
      ++i;
    }
  }

  std::vector<std::vector<unsigned int>> child_item_to_items_vector(child_item_to_item_vector_map.size());
  for (const auto& [child_item_id, item_vector] : child_item_to_item_vector_map) {
    child_item_to_items_vector[child_item_id] = item_vector;
  }
  child_item_to_item_matrix = child_item_to_items_vector;
}

void ConnectivityComputer::
computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                  const ConnectivityMatrix& child_item_to_items_matrix,
                                  CellValuePerNode<unsigned short>& child_item_number_in_item_matrix) const
{
  for (unsigned int r=0; r<child_item_to_items_matrix.numRows(); ++r) {
    const auto& child_item_to_items = child_item_to_items_matrix.rowConst(r);
    for (unsigned short J=0; J<child_item_to_items.length; ++J) {
      const unsigned int j = child_item_to_items(J);
      const auto& item_to_child_items = item_to_child_items_matrix.rowConst(j);

      for (unsigned int R=0; R<item_to_child_items.length; ++R) {
        if (item_to_child_items(R) == r) {
          child_item_number_in_item_matrix(r,J) = R;
          break;
        }
      }
    }
  }
}


void ConnectivityComputer::
computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                  const ConnectivityMatrix& child_item_to_items_matrix,
                                  NodeValuePerCell<unsigned short>& child_item_number_in_item_matrix) const
{
  for (unsigned int r=0; r<child_item_to_items_matrix.numRows(); ++r) {
    const auto& child_item_to_items = child_item_to_items_matrix.rowConst(r);
    for (unsigned short J=0; J<child_item_to_items.length; ++J) {
      const unsigned int j = child_item_to_items(J);
      const auto& item_to_child_items = item_to_child_items_matrix.rowConst(j);

      for (unsigned int R=0; R<item_to_child_items.length; ++R) {
        if (item_to_child_items(R) == r) {
          child_item_number_in_item_matrix(r,J) = R;
          break;
        }
      }
    }
  }
}


void ConnectivityComputer::
computeLocalChildItemNumberInItem(const ConnectivityMatrix& item_to_child_items_matrix,
                                  const ConnectivityMatrix& child_item_to_items_matrix,
                                  CellValuePerFace<unsigned short>& child_item_number_in_item_matrix) const
{
  for (unsigned int r=0; r<child_item_to_items_matrix.numRows(); ++r) {
    const auto& child_item_to_items = child_item_to_items_matrix.rowConst(r);
    for (unsigned short J=0; J<child_item_to_items.length; ++J) {
      const unsigned int j = child_item_to_items(J);
      const auto& item_to_child_items = item_to_child_items_matrix.rowConst(j);

      for (unsigned int R=0; R<item_to_child_items.length; ++R) {
        if (item_to_child_items(R) == r) {
          child_item_number_in_item_matrix(r,J) = R;
          break;
        }
      }
    }
  }
}
