#ifndef I_WRITER_HPP
#define I_WRITER_HPP

#include <output/NamedDiscreteFunction.hpp>

#include <memory>
#include <vector>

class IMesh;

class IWriter
{
 public:
  virtual void writeMesh(const std::shared_ptr<const IMesh>& mesh) const = 0;

  virtual void write(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const = 0;

  virtual void writeIfNeeded(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
    double time) const = 0;

  virtual void writeForced(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
    double time) const = 0;

  IWriter()          = default;
  virtual ~IWriter() = default;
};

#endif   // I_WRITER_HPP
