#ifndef GNUPLOT_WRITER_1D_HPP
#define GNUPLOT_WRITER_1D_HPP

#include <output/WriterBase.hpp>

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <output/OutputNamedItemValueSet.hpp>

class IMesh;

#include <optional>
#include <string>

class GnuplotWriter1D final : public WriterBase
{
 private:
  std::string _getDateAndVersionComment() const;

  std::string _getFilename() const;

  template <typename ItemDataType>
  bool _is_cell_data(const ItemDataType&) const;

  template <typename ItemDataType>
  bool _is_node_data(const ItemDataType&) const;

  template <typename DataType, ItemType item_type>
  size_t _itemDataNbRow(const ItemValue<DataType, item_type>&) const;

  template <typename DataType, ItemType item_type>
  size_t _itemDataNbRow(const ItemArray<DataType, item_type>&) const;

  template <typename MeshType, ItemType item_type>
  void _writeItemDatas(const std::shared_ptr<const MeshType>& mesh,
                       const OutputNamedItemDataSet& output_named_item_data_set,
                       std::ostream& fout) const;

  void _writePreamble(const OutputNamedItemDataSet& output_named_item_value_set, std::ostream& fout) const;

  template <typename MeshType>
  void _write(const std::shared_ptr<const MeshType>& mesh,
              const OutputNamedItemDataSet& output_named_item_value_set,
              std::optional<double> time) const;

  void _writeAtTime(const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list,
                    double time) const final;

  void _write(
    const std::vector<std::shared_ptr<const NamedDiscreteFunction>>& named_discrete_function_list) const final;

  void _writeMesh(const std::shared_ptr<const IMesh>& mesh) const final;

 public:
  GnuplotWriter1D(const std::string& base_filename) : WriterBase(base_filename) {}

  GnuplotWriter1D(const std::string& base_filename, const double time_period) : WriterBase(base_filename, time_period)
  {}

  ~GnuplotWriter1D() = default;
};

#endif   // GNUPLOT_WRITER_1D_HPP
