#include <language/modules/VTKModule.hpp>

#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/TypeDescriptor.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/GmshReader.hpp>
#include <mesh/Mesh.hpp>
#include <output/VTKWriter.hpp>

VTKModule::VTKModule()
{
  this->_addBuiltinFunction("writeVTK",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(std::shared_ptr<const IMesh>, const std::string&)>>(

                              [](std::shared_ptr<const IMesh> p_mesh, const std::string& filename) -> void {
                                VTKWriter writer(filename, 0.1);

                                static double time = 0;

                                switch (p_mesh->dimension()) {
                                case 1: {
                                  using MeshType = Mesh<Connectivity<1>>;
                                  const std::shared_ptr<const MeshType> mesh =
                                    std::dynamic_pointer_cast<const MeshType>(p_mesh);

                                  writer.write(mesh,
                                               OutputNamedItemValueSet{
                                                 NamedItemValue{"cell_number", mesh->connectivity().cellNumber()}},
                                               time, true);
                                  break;
                                }
                                case 2: {
                                  using MeshType = Mesh<Connectivity<2>>;
                                  const std::shared_ptr<const MeshType> mesh =
                                    std::dynamic_pointer_cast<const MeshType>(p_mesh);

                                  writer.write(mesh,
                                               OutputNamedItemValueSet{
                                                 NamedItemValue{"cell_number", mesh->connectivity().cellNumber()}},
                                               time, true);
                                  break;
                                }
                                case 3: {
                                  using MeshType = Mesh<Connectivity<3>>;
                                  const std::shared_ptr<const MeshType> mesh =
                                    std::dynamic_pointer_cast<const MeshType>(p_mesh);

                                  writer.write(mesh,
                                               OutputNamedItemValueSet{
                                                 NamedItemValue{"cell_number", mesh->connectivity().cellNumber()}},
                                               time, true);
                                  break;
                                }
                                }

                                time++;
                              }

                              ));
}
