#include <ConsoleManager.hpp>
#include <PastisOStream.hpp>

#include <rang.hpp>

bool ConsoleManager::isTerminal(std::ostream& os)
{
  return rang::rang_implementation::isTerminal(os.rdbuf());
}

void ConsoleManager::init(const std::string& colorize)
{
  pout() << "Console management: color ";
  if (colorize == "auto") {
    if (isTerminal(pout())) {
      pout() << rang::style::bold
		<< rang::fgB::green
		<< "enabled"
		<< rang::fg::reset
		<< rang::style::reset;
    } else {
      pout() << "disabled";
    }
    pout() << " [auto]\n";
  } else if (colorize == "yes") {
    rang::setControlMode(rang::control::Force);
    pout() << rang::style::bold
	      << rang::fgB::green
	      << "enabled"
	      << rang::fg::reset
	      << rang::style::reset;
    pout() << " ["
	      << rang::style::bold
	      << rang::fgB::red
	      << "forced"
	      << rang::fg::reset
	      << rang::style::reset
	      << "]\n";
  } else if (colorize == "no") {
    rang::setControlMode(rang::control::Off);
    pout() << "disabled [forced]\n";
  } else {
    perr() << "Unknown colorize option: " << colorize << '\n';
    std::exit(1);
  }
}
