#ifndef I_BOUNDARY_CONDITION_DESCRIPTOR_HF_TYPE_HPP
#define I_BOUNDARY_CONDITION_DESCRIPTOR_HF_TYPE_HPP

#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <utils/HighFivePugsUtils.hpp>
#include <utils/PugsMacros.hpp>

HighFive::EnumType<IBoundaryConditionDescriptor::Type> PUGS_INLINE
create_enum_i_boundary_condition_descriptor_type()
{
  return {{"axis", IBoundaryConditionDescriptor::Type::axis},
          {"dirichlet", IBoundaryConditionDescriptor::Type::dirichlet},
          {"external", IBoundaryConditionDescriptor::Type::external},
          {"fixed", IBoundaryConditionDescriptor::Type::fixed},
          {"fourier", IBoundaryConditionDescriptor::Type::fourier},
          {"free", IBoundaryConditionDescriptor::Type::free},
          {"inflow", IBoundaryConditionDescriptor::Type::inflow},
          {"neumann", IBoundaryConditionDescriptor::Type::neumann},
          {"outflow", IBoundaryConditionDescriptor::Type::outflow},
          {"symmetry", IBoundaryConditionDescriptor::Type::symmetry}};
}
HIGHFIVE_REGISTER_TYPE(IBoundaryConditionDescriptor::Type, create_enum_i_boundary_condition_descriptor_type)

#endif   // I_BOUNDARY_CONDITION_DESCRIPTOR_HF_TYPE_HPP
