#ifndef TUPLE_TO_TINY_MATRIX_PROCESSOR_HPP
#define TUPLE_TO_TINY_MATRIX_PROCESSOR_HPP

#include <language/ast/ASTNode.hpp>
#include <language/node_processor/INodeProcessor.hpp>

template <typename TupleProcessorT, size_t N>
class TupleToTinyMatrixProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

  std::unique_ptr<TupleProcessorT> m_tuple_processor;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    AggregateDataVariant v = std::get<AggregateDataVariant>(m_tuple_processor->execute(exec_policy));

    Assert(v.size() == N * N);

    TinyMatrix<N> A;

    for (size_t i = 0, l = 0; i < N; ++i) {
      for (size_t j = 0; j < N; ++j, ++l) {
        std::visit(
          [&](auto&& Aij) {
            using ValueT = std::decay_t<decltype(Aij)>;
            if constexpr (std::is_arithmetic_v<ValueT>) {
              A(i, j) = Aij;
            } else {
              // LCOV_EXCL_START
              Assert(false, "unexpected value type");
              // LCOV_EXCL_STOP
            }
          },
          v[l]);
      }
    }

    return DataVariant{std::move(A)};
  }

  TupleToTinyMatrixProcessor(ASTNode& node) : m_node{node}, m_tuple_processor{std::make_unique<TupleProcessorT>(node)}
  {}

  TupleToTinyMatrixProcessor(ASTNode& node, std::unique_ptr<TupleProcessorT>&& tuple_processor)
    : m_node{node}, m_tuple_processor{std::move(tuple_processor)}
  {}
};

#endif   // TUPLE_TO_TINY_MATRIX_PROCESSOR_HPP
