#include <language/modules/SocketModule.hpp>

#include <language/utils/BinaryOperatorProcessorBuilder.hpp>
#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/OStream.hpp>
#include <language/utils/OperatorRepository.hpp>
#include <utils/Socket.hpp>

SocketModule::SocketModule()
{
  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const Socket>>);

  this->_addBuiltinFunction("createSocketServer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(const uint64_t&)>>(

                              [](const uint64_t& port_number) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(createServerSocket(port_number));
                              }

                              ));

  this->_addBuiltinFunction("acceptSocketClient",
                            std::make_shared<
                              BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(std::shared_ptr<const Socket>)>>(

                              [](std::shared_ptr<const Socket> server_socket) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(acceptClientSocket(*server_socket));
                              }

                              ));

  this->_addBuiltinFunction("connectSocketServer",
                            std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const Socket>(const std::string&,
                                                                                                   const uint64_t&)>>(

                              [](const std::string& hostname,
                                 const uint64_t& port_number) -> std::shared_ptr<const Socket> {
                                return std::make_shared<const Socket>(connectServerSocket(hostname, port_number));
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&, const bool&)>>(

                              [](const std::shared_ptr<const Socket>& socket, const bool& value) -> void {
                                write(*socket, value);
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&, const uint64_t&)>>(

                              [](const std::shared_ptr<const Socket>& socket, const uint64_t& value) -> void {
                                write(*socket, value);
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&, const int64_t&)>>(

                              [](const std::shared_ptr<const Socket>& socket, const int64_t& value) -> void {
                                write(*socket, value);
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&, const double&)>>(

                              [](const std::shared_ptr<const Socket>& socket, const double& value) -> void {
                                write(*socket, value);
                              }

                              ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyVector<1>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyVector<1>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyVector<2>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyVector<2>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyVector<3>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyVector<3>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyMatrix<1>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyMatrix<1>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyMatrix<2>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyMatrix<2>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write", std::make_shared<BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&,
                                                                                   const TinyMatrix<3>&)>>(

                                       [](const std::shared_ptr<const Socket>& socket,
                                          const TinyMatrix<3>& value) -> void { write(*socket, value); }

                                       ));

  this->_addBuiltinFunction("write",
                            std::make_shared<
                              BuiltinFunctionEmbedder<void(const std::shared_ptr<const Socket>&, const std::string&)>>(

                              [](const std::shared_ptr<const Socket>& socket, const std::string& value) -> void {
                                write(*socket, value.size());
                                write(*socket, value);
                              }

                              ));

  this->_addBuiltinFunction("read_B",
                            std::make_shared<BuiltinFunctionEmbedder<bool(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> bool {
                                bool value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_N",
                            std::make_shared<BuiltinFunctionEmbedder<uint64_t(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> uint64_t {
                                uint64_t value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_Z",
                            std::make_shared<BuiltinFunctionEmbedder<int64_t(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> int64_t {
                                int64_t value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_R",
                            std::make_shared<BuiltinFunctionEmbedder<double(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> double {
                                double value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_R1", std::make_shared<
                                         BuiltinFunctionEmbedder<TinyVector<1>(const std::shared_ptr<const Socket>&)>>(

                                         [](const std::shared_ptr<const Socket>& socket) -> TinyVector<1> {
                                           TinyVector<1> value;
                                           read(*socket, value);

                                           return value;
                                         }

                                         ));

  this->_addBuiltinFunction("read_R2", std::make_shared<
                                         BuiltinFunctionEmbedder<TinyVector<2>(const std::shared_ptr<const Socket>&)>>(

                                         [](const std::shared_ptr<const Socket>& socket) -> TinyVector<2> {
                                           TinyVector<2> value;
                                           read(*socket, value);

                                           return value;
                                         }

                                         ));

  this->_addBuiltinFunction("read_R3", std::make_shared<
                                         BuiltinFunctionEmbedder<TinyVector<3>(const std::shared_ptr<const Socket>&)>>(

                                         [](const std::shared_ptr<const Socket>& socket) -> TinyVector<3> {
                                           TinyVector<3> value;
                                           read(*socket, value);

                                           return value;
                                         }

                                         ));

  this->_addBuiltinFunction("read_R1x1",
                            std::make_shared<
                              BuiltinFunctionEmbedder<TinyMatrix<1>(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> TinyMatrix<1> {
                                TinyMatrix<1> value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_R2x2",
                            std::make_shared<
                              BuiltinFunctionEmbedder<TinyMatrix<2>(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> TinyMatrix<2> {
                                TinyMatrix<2> value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this->_addBuiltinFunction("read_R3x3",
                            std::make_shared<
                              BuiltinFunctionEmbedder<TinyMatrix<3>(const std::shared_ptr<const Socket>&)>>(

                              [](const std::shared_ptr<const Socket>& socket) -> TinyMatrix<3> {
                                TinyMatrix<3> value;
                                read(*socket, value);

                                return value;
                              }

                              ));

  this
    ->_addBuiltinFunction("read_string",
                          std::make_shared<BuiltinFunctionEmbedder<std::string(const std::shared_ptr<const Socket>&)>>(

                            [](const std::shared_ptr<const Socket>& socket) -> std::string {
                              size_t size;
                              read(*socket, size);
                              std::string value;
                              if (size > 0) {
                                value.resize(size);
                                read(*socket, value);
                              }
                              return value;
                            }

                            ));
}

void
SocketModule::registerOperators() const
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addBinaryOperator<language::shift_left_op>(
    std::make_shared<BinaryOperatorProcessorBuilder<language::shift_left_op, std::shared_ptr<const OStream>,
                                                    std::shared_ptr<const OStream>, std::shared_ptr<const Socket>>>());
}
