#ifndef LINEAR_SOLVER_HPP
#define LINEAR_SOLVER_HPP

#include <algebra/CRSMatrix.hpp>
#include <algebra/LinearSolverOptions.hpp>
#include <algebra/SmallMatrix.hpp>
#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <utils/Exceptions.hpp>

class LinearSolver
{
 private:
  struct Internals;

  const LinearSolverOptions m_options;

 public:
  bool hasLibrary(LSLibrary library) const;
  void checkOptions(const LinearSolverOptions& options) const;

  template <size_t N>
  void
  solveLocalSystem(const TinyMatrix<N>& A, TinyVector<N>& x, const TinyVector<N>& b)
  {
    SmallMatrix A_dense{A};

    SmallVector x_vector{x};
    SmallVector b_vector{b};

    this->solveLocalSystem(A_dense, x_vector, b_vector);

    for (size_t i = 0; i < N; ++i) {
      x[i] = x_vector[i];
    }
  }

  void solveLocalSystem(const CRSMatrix<double, int>& A, Vector<double>& x, const Vector<const double>& b);
  void solveLocalSystem(const SmallMatrix<double>& A, SmallVector<double>& x, const SmallVector<const double>& b);

  LinearSolver();
  LinearSolver(const LinearSolverOptions& options);
};

#endif   // LINEAR_SOLVER_HPP
