#ifndef MESH_SMOOTHER_ESCOBAR_HPP
#define MESH_SMOOTHER_ESCOBAR_HPP

#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <vector>

class FunctionSymbolId;
class IZoneDescriptor;
class DiscreteFunctionVariant;
class ItemValueVariant;

class MeshSmootherEscobarHandler
{
 private:
  template <size_t Dimension>
  class MeshSmootherEscobar;

 public:
  std::shared_ptr<const ItemValueVariant> getQuality(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const;

  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const;

  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const FunctionSymbolId& function_symbol_id) const;

  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::vector<std::shared_ptr<const IZoneDescriptor>>& smoothing_zone_list) const;

  std::shared_ptr<const IMesh> getSmoothedMesh(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::vector<std::shared_ptr<const DiscreteFunctionVariant>>& smoothing_zone_list) const;

  MeshSmootherEscobarHandler()                             = default;
  MeshSmootherEscobarHandler(MeshSmootherEscobarHandler&&) = default;
  ~MeshSmootherEscobarHandler()                            = default;
};

#endif   // MESH_SMOOTHER_ESCOBAR_HPP
