#ifndef MESH_LINE_EDGE_BOUNDARY_HPP
#define MESH_LINE_EDGE_BOUNDARY_HPP

#include <algebra/TinyMatrix.hpp>
#include <mesh/MeshEdgeBoundary.hpp>

template <size_t Dimension>
class [[nodiscard]] MeshLineEdgeBoundary final
  : public MeshEdgeBoundary<Dimension>   // clazy:exclude=copyable-polymorphic
{
 public:
  static_assert(Dimension > 1, "MeshLineEdgeBoundary makes only sense in dimension 1");

  using Rd = TinyVector<Dimension, double>;

 private:
  const Rd m_direction;

 public:
  template <size_t MeshDimension>
  friend MeshLineEdgeBoundary<MeshDimension> getMeshLineEdgeBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                                     const IBoundaryDescriptor& boundary_descriptor);

  PUGS_INLINE
  const Rd& direction() const
  {
    return m_direction;
  }

  MeshLineEdgeBoundary& operator=(const MeshLineEdgeBoundary&) = default;
  MeshLineEdgeBoundary& operator=(MeshLineEdgeBoundary&&) = default;

 private:
  MeshLineEdgeBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefEdgeList& ref_edge_list, const Rd& direction)
    : MeshEdgeBoundary<Dimension>(mesh, ref_edge_list), m_direction(direction)
  {}

 public:
  MeshLineEdgeBoundary()                            = default;
  MeshLineEdgeBoundary(const MeshLineEdgeBoundary&) = default;
  MeshLineEdgeBoundary(MeshLineEdgeBoundary &&)     = default;
  ~MeshLineEdgeBoundary()                           = default;
};

template <size_t Dimension>
MeshLineEdgeBoundary<Dimension> getMeshLineEdgeBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                        const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_LINE_EDGE_BOUNDARY_HPP
