#include <mesh/MeshFlatFaceBoundary.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshFlatNodeBoundary.hpp>

template <size_t Dimension>
MeshFlatFaceBoundary<Dimension>
getMeshFlatFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh, const IBoundaryDescriptor& boundary_descriptor)
{
  MeshFaceBoundary<Dimension> mesh_face_boundary          = getMeshFaceBoundary(mesh, boundary_descriptor);
  MeshFlatNodeBoundary<Dimension> mesh_flat_node_boundary = getMeshFlatNodeBoundary(mesh, boundary_descriptor);

  return MeshFlatFaceBoundary<Dimension>{mesh, mesh_face_boundary.refFaceList(),
                                         mesh_flat_node_boundary.outgoingNormal()};
}

template MeshFlatFaceBoundary<1> getMeshFlatFaceBoundary(const Mesh<Connectivity<1>>&, const IBoundaryDescriptor&);
template MeshFlatFaceBoundary<2> getMeshFlatFaceBoundary(const Mesh<Connectivity<2>>&, const IBoundaryDescriptor&);
template MeshFlatFaceBoundary<3> getMeshFlatFaceBoundary(const Mesh<Connectivity<3>>&, const IBoundaryDescriptor&);
