#ifndef MESH_EDGE_INTERFACE_HPP
#define MESH_EDGE_INTERFACE_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/IInterfaceDescriptor.hpp>
#include <mesh/RefItemList.hpp>
#include <utils/Array.hpp>

template <size_t Dimension>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <size_t Dimension>
class [[nodiscard]] MeshEdgeInterface   // clazy:exclude=copyable-polymorphic
{
 protected:
  RefEdgeList m_ref_edge_list;

 public:
  template <size_t MeshDimension>
  friend MeshEdgeInterface<MeshDimension> getMeshEdgeInterface(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                               const IInterfaceDescriptor& interface_descriptor);

  MeshEdgeInterface& operator=(const MeshEdgeInterface&) = default;
  MeshEdgeInterface& operator=(MeshEdgeInterface&&) = default;

  PUGS_INLINE
  const RefEdgeList& refEdgeList() const
  {
    return m_ref_edge_list;
  }

  PUGS_INLINE
  const Array<const EdgeId>& edgeList() const
  {
    return m_ref_edge_list.list();
  }

 protected:
  MeshEdgeInterface(const Mesh<Connectivity<Dimension>>& mesh, const RefEdgeList& ref_edge_list);
  MeshEdgeInterface(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list);

 public:
  MeshEdgeInterface(const MeshEdgeInterface&) = default;   // LCOV_EXCL_LINE
  MeshEdgeInterface(MeshEdgeInterface &&)     = default;   // LCOV_EXCL_LINE

  MeshEdgeInterface()          = default;
  virtual ~MeshEdgeInterface() = default;
};

template <size_t Dimension>
MeshEdgeInterface<Dimension> getMeshEdgeInterface(const Mesh<Connectivity<Dimension>>& mesh,
                                                  const IInterfaceDescriptor& interface_descriptor);

#endif   // MESH_EDGE_INTERFACE_HPP
