#ifndef UPWIND_IMPLICIT_TRAFFIC_SOLVER_HPP
#define UPWIND_IMPLICIT_TRAFFIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;

class UpwindImplicitTrafficSolverHandler
{
 private:
  struct IUpwindImplicitTrafficSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>, std::shared_ptr<const DiscreteFunctionVariant>> apply(
      const double& dt,
      const std::shared_ptr<const DiscreteFunctionVariant>& tau) const = 0;

    IUpwindImplicitTrafficSolver()                                          = default;
    IUpwindImplicitTrafficSolver(IUpwindImplicitTrafficSolver&&)            = default;
    IUpwindImplicitTrafficSolver& operator=(IUpwindImplicitTrafficSolver&&) = default;

    virtual ~IUpwindImplicitTrafficSolver() = default;
  };

  template <MeshConcept MeshType>
  class UpwindImplicitTrafficSolver;

  std::unique_ptr<IUpwindImplicitTrafficSolver> m_upwind_implicit_traffic_solver;

 public:
  const IUpwindImplicitTrafficSolver&
  solver() const
  {
    return *m_upwind_implicit_traffic_solver;
  }

  UpwindImplicitTrafficSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& tau,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const double& dt);
};

#endif   // UPWIND_IMPLICIT_TRAFFIC_SOLVER_HPP
