#ifndef UPWIND_EXPLICIT_TRAFFIC_SOLVER_HPP
#define UPWIND_EXPLICIT_TRAFFIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;

double acoustic_dt_traffic_flow(const std::shared_ptr<const DiscreteFunctionVariant>& c,
                                const std::shared_ptr<const DiscreteFunctionVariant>& tau);

class UpwindExplicitTrafficSolverHandler
{
 private:
  struct IUpwindExplicitTrafficSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>, std::shared_ptr<const DiscreteFunctionVariant>> apply(
      const double& dt,
      const std::shared_ptr<const DiscreteFunctionVariant>& tau) const = 0;

    IUpwindExplicitTrafficSolver()                                          = default;
    IUpwindExplicitTrafficSolver(IUpwindExplicitTrafficSolver&&)            = default;
    IUpwindExplicitTrafficSolver& operator=(IUpwindExplicitTrafficSolver&&) = default;

    virtual ~IUpwindExplicitTrafficSolver() = default;
  };

  template <MeshConcept MeshType>
  class UpwindExplicitTrafficSolver;

  std::unique_ptr<IUpwindExplicitTrafficSolver> m_upwind_explicit_traffic_solver;

 public:
  const IUpwindExplicitTrafficSolver&
  solver() const
  {
    return *m_upwind_explicit_traffic_solver;
  }

  UpwindExplicitTrafficSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& tau,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list);
};

#endif   // UPWIND_EXPLICIT_TRAFFIC_SOLVER_HPP
