#ifndef RELAXED_IMPLICIT_ACOUSTIC_SOLVER_HPP
#define RELAXED_IMPLICIT_ACOUSTIC_SOLVER_HPP

#include <rang.hpp>

#include <utils/PugsAssert.hpp>

#include <algebra/CRSMatrix.hpp>
#include <algebra/CRSMatrixDescriptor.hpp>
#include <algebra/LinearSolver.hpp>
#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>
#include <algebra/Vector.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshTraits.hpp>

#include <mesh/ItemValueUtils.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/MeshNodeBoundary.hpp>
#include <mesh/SubItemValuePerItem.hpp>
#include <utils/Messenger.hpp>

#include <iostream>
#include <memory>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;

class RelaxedImplicitAcousticSolverHandler
{
 private:
  struct IRelaxedImplicitAcousticSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E) const = 0;

    IRelaxedImplicitAcousticSolver()                                            = default;
    IRelaxedImplicitAcousticSolver(IRelaxedImplicitAcousticSolver&&)            = default;
    IRelaxedImplicitAcousticSolver& operator=(IRelaxedImplicitAcousticSolver&&) = default;

    virtual ~IRelaxedImplicitAcousticSolver() = default;
  };

  template <MeshConcept MeshType>
  class RelaxedImplicitAcousticSolver;

  std::unique_ptr<IRelaxedImplicitAcousticSolver> m_implicit_acoustic_solver;

 public:
  const IRelaxedImplicitAcousticSolver&
  solver() const
  {
    return *m_implicit_acoustic_solver;
  }

  RelaxedImplicitAcousticSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& rho,
    const std::shared_ptr<const DiscreteFunctionVariant>& c,
    const std::shared_ptr<const DiscreteFunctionVariant>& u,
    const std::shared_ptr<const DiscreteFunctionVariant>& p,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const double& dt);
};

#endif   // RELAXED_IMPLICIT_ACOUSTIC_SOLVER_HPP
