#ifndef LINEAR_IMPLICIT_ACOUSTIC_SOLVER_HPP
#define LINEAR_IMPLICIT_ACOUSTIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;
class IBoundaryConditionDescriptor;
class IZoneDescriptor;

class LinearImplicitAcousticSolverHandler
{
 private:
  struct ILinearImplicitAcousticSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E) const = 0;

    ILinearImplicitAcousticSolver()                                           = default;
    ILinearImplicitAcousticSolver(ILinearImplicitAcousticSolver&&)            = default;
    ILinearImplicitAcousticSolver& operator=(ILinearImplicitAcousticSolver&&) = default;

    virtual ~ILinearImplicitAcousticSolver() = default;
  };

  template <MeshConcept MeshType>
  class LinearImplicitAcousticSolver;

  std::unique_ptr<ILinearImplicitAcousticSolver> m_implicit_acoustic_solver;

 public:
  const ILinearImplicitAcousticSolver&
  solver() const
  {
    return *m_implicit_acoustic_solver;
  }

  LinearImplicitAcousticSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& rho,
    const std::shared_ptr<const DiscreteFunctionVariant>& c,
    const std::shared_ptr<const DiscreteFunctionVariant>& u,
    const std::shared_ptr<const DiscreteFunctionVariant>& p,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const double& dt);
};

#endif   // LINEAR_IMPLICIT_ACOUSTIC_SOLVER_HPP
