#ifndef IMPLICIT_ITERATIVE_TRAFFIC_SOLVER_HPP
#define IMPLICIT_ITERATIVE_TRAFFIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;

class ImplicitIterativeTrafficSolverHandler
{
 private:
  struct IImplicitIterativeTrafficSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>, std::shared_ptr<const DiscreteFunctionVariant>> apply(
      const double& dt,
      const std::shared_ptr<const DiscreteFunctionVariant>& tau) const = 0;

    IImplicitIterativeTrafficSolver()                                             = default;
    IImplicitIterativeTrafficSolver(IImplicitIterativeTrafficSolver&&)            = default;
    IImplicitIterativeTrafficSolver& operator=(IImplicitIterativeTrafficSolver&&) = default;

    virtual ~IImplicitIterativeTrafficSolver() = default;
  };

  template <MeshConcept MeshType>
  class ImplicitIterativeTrafficSolver;

  std::unique_ptr<IImplicitIterativeTrafficSolver> m_implicit_iterative_traffic_solver;

 public:
  const IImplicitIterativeTrafficSolver&
  solver() const
  {
    return *m_implicit_iterative_traffic_solver;
  }
  ImplicitIterativeTrafficSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& tau,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const double& dt);
};

#endif   // IMPLICIT_ITERATIVE_TRAFFIC_SOLVER_HPP
