#ifndef IMPLICIT_EXACT_TRAFFIC_SOLVER_HPP
#define IMPLICIT_EXACT_TRAFFIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;

class ImplicitExactTrafficSolverHandler
{
 private:
  struct IImplicitExactTrafficSolver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>, std::shared_ptr<const DiscreteFunctionVariant>> apply(
      const double& dt,
      const std::shared_ptr<const DiscreteFunctionVariant>& tau) const = 0;

    IImplicitExactTrafficSolver()                                         = default;
    IImplicitExactTrafficSolver(IImplicitExactTrafficSolver&&)            = default;
    IImplicitExactTrafficSolver& operator=(IImplicitExactTrafficSolver&&) = default;

    virtual ~IImplicitExactTrafficSolver() = default;
  };

  template <MeshConcept MeshType>
  class ImplicitExactTrafficSolver;

  std::unique_ptr<IImplicitExactTrafficSolver> m_implicit_exact_traffic_solver;

 public:
  const IImplicitExactTrafficSolver&
  solver() const
  {
    return *m_implicit_exact_traffic_solver;
  }

  ImplicitExactTrafficSolverHandler(
    const std::shared_ptr<const DiscreteFunctionVariant>& tau,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const double& dt);
};

#endif   // IMPLICIT_EXACT_TRAFFIC_SOLVER_HPP
