#ifndef IMPLICIT_ACOUSTIC_O2_SOLVER_HPP
#define IMPLICIT_ACOUSTIC_O2_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;
class IBoundaryConditionDescriptor;
class IZoneDescriptor;

class ImplicitAcousticO2SolverHandler
{
 public:
  enum class SolverType
  {
    Glace1State,
    Glace2States,
    Eucclhyd
  };

 private:
  struct IImplicitAcousticO2Solver
  {
    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const double& dt,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& c,
          const std::shared_ptr<const DiscreteFunctionVariant>& p,
          const std::shared_ptr<const DiscreteFunctionVariant>& pi,
          const std::shared_ptr<const DiscreteFunctionVariant>& gamma,
          const std::shared_ptr<const DiscreteFunctionVariant>& Cv,
          const std::shared_ptr<const DiscreteFunctionVariant>& entropy) = 0;

    IImplicitAcousticO2Solver()                                       = default;
    IImplicitAcousticO2Solver(IImplicitAcousticO2Solver&&)            = default;
    IImplicitAcousticO2Solver& operator=(IImplicitAcousticO2Solver&&) = default;

    virtual ~IImplicitAcousticO2Solver() = default;
  };

  template <MeshConcept MeshType>
  class ImplicitAcousticO2Solver;

  std::unique_ptr<IImplicitAcousticO2Solver> m_implicit_acoustic_solver;

 public:
  IImplicitAcousticO2Solver&
  solver()
  {
    return *m_implicit_acoustic_solver;
  }

  ImplicitAcousticO2SolverHandler(
    SolverType solver_type,
    const std::shared_ptr<const DiscreteFunctionVariant>& rho,
    const std::shared_ptr<const DiscreteFunctionVariant>& c,
    const std::shared_ptr<const DiscreteFunctionVariant>& u,
    const std::shared_ptr<const DiscreteFunctionVariant>& p,
    const std::shared_ptr<const DiscreteFunctionVariant>& pi,
    const std::shared_ptr<const DiscreteFunctionVariant>& gamma,
    const std::shared_ptr<const DiscreteFunctionVariant>& Cv,
    const std::shared_ptr<const DiscreteFunctionVariant>& entropy,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::vector<std::shared_ptr<const IZoneDescriptor>>& explicit_zone_list,
    const double& dt);

  ImplicitAcousticO2SolverHandler(
    const SolverType solver_type,
    const std::shared_ptr<const DiscreteFunctionVariant>& rho,
    const std::shared_ptr<const DiscreteFunctionVariant>& c,
    const std::shared_ptr<const DiscreteFunctionVariant>& u,
    const std::shared_ptr<const DiscreteFunctionVariant>& p,
    const std::shared_ptr<const DiscreteFunctionVariant>& pi,
    const std::shared_ptr<const DiscreteFunctionVariant>& gamma,
    const std::shared_ptr<const DiscreteFunctionVariant>& Cv,
    const std::shared_ptr<const DiscreteFunctionVariant>& entropy,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const std::shared_ptr<const DiscreteFunctionVariant>& chi_explicit,
    const double& dt);
};

#endif   // IMPLICIT_ACOUSTIC_O2_SOLVER_HPP
