#ifndef UPWIND_EXPLICIT_TRAFFIC_ALGORITHM_HPP
#define UPWIND_EXPLICIT_TRAFFIC_ALGORITHM_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <string>
#include <variant>
#include <vector>

class DiscreteFunctionVariant;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;
class IBoundaryConditionDescriptor;
class FunctionSymbolId;

template <MeshConcept MeshType>
struct UpwindExplicitTrafficAlgorithm
{
  class VelocityBoundaryCondition;
  class FreeBoundaryCondition;

  using BoundaryCondition = std::variant<VelocityBoundaryCondition, FreeBoundaryCondition>;

  using BoundaryConditionList = std::vector<BoundaryCondition>;

  UpwindExplicitTrafficAlgorithm(
    std::shared_ptr<const MeshVariant> mesh_v,
    const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
    const FunctionSymbolId& tau_id,
    const double& tmax);
};

#endif   // UPWIND_EXPLICIT_TRAFFIC_ALGORITHM_HPP
