#ifndef NEWTON_TRAFFIC_ALGORITHM_HPP
#define NEWTON_TRAFFIC_ALGORITHM_HPP

#include <mesh/MeshTraits.hpp>

#include <language/utils/FunctionSymbolId.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <string>
#include <variant>
#include <vector>

class MeshVariant;

template <MeshConcept MeshType>
struct NewtonTrafficAlgorithm
{
  class VelocityBoundaryCondition;
  class FreeBoundaryCondition;

  using BoundaryCondition = std::variant<VelocityBoundaryCondition, FreeBoundaryCondition>;

  using BoundaryConditionList = std::vector<BoundaryCondition>;

  NewtonTrafficAlgorithm(std::shared_ptr<const MeshVariant> mesh_v,
                         const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                         const FunctionSymbolId& tau_id,
                         const double& tmax,
                         const double& given_dt);
};

#endif   // NEWTON_TRAFFIC_ALGORITHM_HPP
