#ifndef IMPLICIT_TRAFFIC_ALGORITHM_HPP
#define IMPLICIT_TRAFFIC_ALGORITHM_HPP

#include <mesh/MeshTraits.hpp>

#include <language/utils/FunctionSymbolId.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <string>
#include <variant>
#include <vector>

class MeshVariant;

template <MeshConcept MeshType>
struct ImplicitTrafficAlgorithm
{
  class VelocityBoundaryCondition;
  class FreeBoundaryCondition;

  using BoundaryCondition = std::variant<VelocityBoundaryCondition, FreeBoundaryCondition>;

  using BoundaryConditionList = std::vector<BoundaryCondition>;

  ImplicitTrafficAlgorithm(std::shared_ptr<const MeshVariant> mesh_v,
                           const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                           const FunctionSymbolId& tau_id,
                           const double& tmax,
                           const double& given_dt);
};

#endif   // IMPLICIT_TRAFFIC_ALGORITHM_HPP
