#ifndef SOCKET_MODULE_HPP
#define SOCKET_MODULE_HPP

#include <language/modules/BuiltinModule.hpp>
#include <language/utils/ASTNodeDataTypeTraits.hpp>

class Socket;

template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const Socket>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("socket");

class SocketModule : public BuiltinModule
{
 public:
  std::string_view
  name() const final
  {
    return "socket";
  }

  void registerOperators() const final;

  SocketModule();
  ~SocketModule() = default;
};

#endif   // SOCKET_MODULE_HPP
