#include <language/modules/WriterModule.hpp>

#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/TypeDescriptor.hpp>
#include <mesh/Connectivity.hpp>
#include <mesh/GmshReader.hpp>
#include <mesh/ItemArrayVariant.hpp>
#include <mesh/ItemValueVariant.hpp>
#include <mesh/Mesh.hpp>
#include <output/GnuplotWriter.hpp>
#include <output/GnuplotWriter1D.hpp>
#include <output/GnuplotWriterRaw.hpp>
#include <output/IWriter.hpp>
#include <output/NamedDiscreteFunction.hpp>
#include <output/NamedItemArrayVariant.hpp>
#include <output/NamedItemValueVariant.hpp>
#include <output/VTKWriter.hpp>
#include <scheme/DiscreteFunctionVariant.hpp>

WriterModule::WriterModule()
{
  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const INamedDiscreteData>>);

  this->_addTypeDescriptor(ast_node_data_type_from<std::shared_ptr<const IWriter>>);

  this->_addBuiltinFunction("vtk_writer", std::function(

                                            [](const std::string& filename) -> std::shared_ptr<const IWriter> {
                                              return std::make_shared<VTKWriter>(filename);
                                            }

                                            ));

  this->_addBuiltinFunction("vtk_writer",
                            std::function(

                              [](const std::string& filename, const double& period) -> std::shared_ptr<const IWriter> {
                                return std::make_shared<VTKWriter>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("gnuplot_writer", std::function(

                                                [](const std::string& filename) -> std::shared_ptr<const IWriter> {
                                                  return std::make_shared<GnuplotWriter>(filename);
                                                }

                                                ));

  this->_addBuiltinFunction("gnuplot_writer",
                            std::function(

                              [](const std::string& filename, const double& period) -> std::shared_ptr<const IWriter> {
                                return std::make_shared<GnuplotWriter>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("gnuplot_1d_writer", std::function(

                                                   [](const std::string& filename) -> std::shared_ptr<const IWriter> {
                                                     return std::make_shared<GnuplotWriter1D>(filename);
                                                   }

                                                   ));

  this->_addBuiltinFunction("gnuplot_1d_writer",
                            std::function(

                              [](const std::string& filename, const double& period) -> std::shared_ptr<const IWriter> {
                                return std::make_shared<GnuplotWriter1D>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("gnuplot_raw_writer", std::function(

                                                    [](const std::string& filename) -> std::shared_ptr<const IWriter> {
                                                      return std::make_shared<GnuplotWriterRaw>(filename);
                                                    }

                                                    ));

  this->_addBuiltinFunction("gnuplot_raw_writer",
                            std::function(

                              [](const std::string& filename, const double& period) -> std::shared_ptr<const IWriter> {
                                return std::make_shared<GnuplotWriterRaw>(filename, period);
                              }

                              ));

  this->_addBuiltinFunction("name_output", std::function(

                                             [](std::shared_ptr<const DiscreteFunctionVariant> discrete_function,
                                                const std::string& name) -> std::shared_ptr<const INamedDiscreteData> {
                                               return std::make_shared<const NamedDiscreteFunction>(discrete_function,
                                                                                                    name);
                                             }

                                             ));

  this->_addBuiltinFunction("name_output", std::function(

                                             [](std::shared_ptr<const ItemValueVariant> item_value_variant,
                                                const std::string& name) -> std::shared_ptr<const INamedDiscreteData> {
                                               return std::make_shared<const NamedItemValueVariant>(item_value_variant,
                                                                                                    name);
                                             }

                                             ));

  this->_addBuiltinFunction("name_output", std::function(

                                             [](std::shared_ptr<const ItemArrayVariant> item_array_variant,
                                                const std::string& name) -> std::shared_ptr<const INamedDiscreteData> {
                                               return std::make_shared<const NamedItemArrayVariant>(item_array_variant,
                                                                                                    name);
                                             }

                                             ));

  this->_addBuiltinFunction("write_mesh",
                            std::function(

                              [](std::shared_ptr<const IWriter> writer,
                                 std::shared_ptr<const MeshVariant> mesh_v) -> void { writer->writeMesh(mesh_v); }

                              ));

  this->_addBuiltinFunction("write", std::function(

                                       [](std::shared_ptr<const IWriter> writer,
                                          const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                            named_discrete_function_list) -> void {
                                         writer->write(named_discrete_function_list);
                                       }

                                       ));

  this->_addBuiltinFunction("write", std::function(

                                       [](std::shared_ptr<const IWriter> writer,
                                          const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                            named_discrete_function_list,
                                          const double& time) -> void {
                                         writer->writeIfNeeded(named_discrete_function_list, time);
                                       }

                                       ));

  this->_addBuiltinFunction("force_write", std::function(

                                             [](std::shared_ptr<const IWriter> writer,
                                                const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                                  named_discrete_function_list,
                                                const double& time) -> void {
                                               writer->writeForced(named_discrete_function_list, time);
                                             }

                                             ));

  this->_addBuiltinFunction("write",
                            std::function(

                              [](std::shared_ptr<const IWriter> writer, std::shared_ptr<const MeshVariant> mesh_v,
                                 const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                   named_discrete_function_list) -> void {
                                writer->writeOnMesh(mesh_v, named_discrete_function_list);
                              }

                              ));

  this->_addBuiltinFunction("write",
                            std::function(

                              [](std::shared_ptr<const IWriter> writer, std::shared_ptr<const MeshVariant> mesh_v,
                                 const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                   named_discrete_function_list,
                                 const double& time) -> void {
                                writer->writeOnMeshIfNeeded(mesh_v, named_discrete_function_list, time);
                              }

                              ));

  this->_addBuiltinFunction("force_write",
                            std::function(

                              [](std::shared_ptr<const IWriter> writer, std::shared_ptr<const MeshVariant> mesh_v,
                                 const std::vector<std::shared_ptr<const INamedDiscreteData>>&
                                   named_discrete_function_list,
                                 const double& time) -> void {
                                writer->writeOnMeshForced(mesh_v, named_discrete_function_list, time);
                              }

                              ));
}

void
WriterModule::registerOperators() const
{}
