#ifndef UNSTEADY_ELASTICITY_HPP
#define UNSTEADY_ELASTICITY_HPP

#include <algebra/TinyVector.hpp>
#include <language/utils/FunctionSymbolId.hpp>
#include <memory>
#include <mesh/IMesh.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>
#include <variant>
#include <vector>

template <size_t Dimension>
class UnsteadyElasticity
{
 private:
  class DirichletBoundaryCondition;
  class NormalStrainBoundaryCondition;
  class SymmetryBoundaryCondition;
  class InterpolationWeightsManager;

 public:
  UnsteadyElasticity(std::shared_ptr<const IMesh> i_mesh,
                     const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                     const FunctionSymbolId& lambda_id,
                     const FunctionSymbolId& mu_id,
                     const FunctionSymbolId& f_id,
                     const FunctionSymbolId& U_id,
                     const FunctionSymbolId& U_init_id,
                     const double& Tf,
                     const double& dt);
};

#endif   // ELASTICITY_DIAMOND_ALGORITHM2_HPP
