#ifndef PARABOLIC_HEAT_HPP
#define PARABOLIC_HEAT_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <variant>
#include <vector>

template <size_t Dimension>
class ParabolicHeatScheme
{
 private:
  class DirichletBoundaryCondition;
  class FourierBoundaryCondition;
  class NeumannBoundaryCondition;
  class SymmetryBoundaryCondition;
  class InterpolationWeightsManager;

 public:
  ParabolicHeatScheme(std::shared_ptr<const IMesh> i_mesh,
                      const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                      const FunctionSymbolId& T_id,
                      const FunctionSymbolId& T_init_id,
                      const FunctionSymbolId& kappa_id,
                      const FunctionSymbolId& f_id,
                      const double& final_time,
                      const double& dt);
};

#endif   // HEAT_DIAMOND_ALGORITHM_HPP
