#ifndef HEAT_DIAMOND_ALGORITHM2_HPP
#define HEAT_DIAMOND_ALGORITHM2_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <variant>
#include <vector>

template <size_t Dimension>
class HeatDiamondScheme2
{
 private:
  class DirichletBoundaryCondition;
  class FourierBoundaryCondition;
  class NeumannBoundaryCondition;
  class SymmetryBoundaryCondition;

 public:
  HeatDiamondScheme2(std::shared_ptr<const IMesh> i_mesh,
                     const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                     const FunctionSymbolId& T_id,
                     const FunctionSymbolId& kappa_id,
                     const FunctionSymbolId& f_id);
};

#endif   // HEAT_DIAMOND_ALGORITHM2_HPP
