#ifndef HEAT_5POINTS_ALGORITHM_HPP
#define HEAT_5POINTS_ALGORITHM_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>
#include <vector>

template <size_t Dimension>
struct Heat5PointsAlgorithm
{
  Heat5PointsAlgorithm(std::shared_ptr<const IMesh> i_mesh,
                       const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                       const FunctionSymbolId& T_id,
                       const FunctionSymbolId& kappa_id,
                       const FunctionSymbolId& f_id);
};

#endif   // HEAT_5POINTS_ALGORITHM_HPP
