#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <sstream>

#define CHECK_UNARY_EXPRESSION_RESULT(data, variable_name, expected_value)    \
  {                                                                           \
    string_input input{data, "test.pgs"};                                     \
    auto ast = ASTBuilder::build(input);                                      \
                                                                              \
    ASTSymbolTableBuilder{*ast};                                              \
    ASTNodeDataTypeBuilder{*ast};                                             \
    ASTNodeValueBuilder{*ast};                                                \
                                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};                           \
    ASTNodeTypeCleaner<language::declaration>{*ast};                          \
                                                                              \
    ASTNodeExpressionBuilder{*ast};                                           \
    ExecUntilBreakOrContinue exec_policy;                                     \
    ast->execute(exec_policy);                                                \
                                                                              \
    auto symbol_table = ast->m_symbol_table;                                  \
                                                                              \
    using namespace TAO_PEGTL_NAMESPACE;                                      \
    position use_position{internal::iterator{"fixture"}, "fixture"};          \
    use_position.byte    = 10000;                                             \
    auto [symbol, found] = symbol_table->find(variable_name, use_position);   \
                                                                              \
    auto attributes = symbol->attributes();                                   \
    auto value      = std::get<decltype(expected_value)>(attributes.value()); \
                                                                              \
    REQUIRE(value == expected_value);                                         \
  }

TEST_CASE("UnaryExpressionProcessor", "[language]")
{
  SECTION("unary minus")
  {
    CHECK_UNARY_EXPRESSION_RESULT(R"(N n = 2; Z z = -n;)", "z", -2l);
    CHECK_UNARY_EXPRESSION_RESULT(R"(Z p = 2; Z q = -p;)", "q", -2l);
    CHECK_UNARY_EXPRESSION_RESULT(R"(R r = 2; r = -r;)", "r", -2.);
  }

  SECTION("unary not")
  {
    CHECK_UNARY_EXPRESSION_RESULT(R"(B b = false; b = not b;)", "b", true);
    CHECK_UNARY_EXPRESSION_RESULT(R"(B b = true; b = not b;)", "b", false);
    CHECK_UNARY_EXPRESSION_RESULT(R"(N n = 0; B b = not n;)", "b", true);
    CHECK_UNARY_EXPRESSION_RESULT(R"(N n = 2; B b = not n;)", "b", false);
    CHECK_UNARY_EXPRESSION_RESULT(R"(Z z = 0; B b = not z;)", "b", true);
    CHECK_UNARY_EXPRESSION_RESULT(R"(Z z = -2; B b = not z;)", "b", false);
    CHECK_UNARY_EXPRESSION_RESULT(R"(R r = 0; B b = not r;)", "b", true);
    CHECK_UNARY_EXPRESSION_RESULT(R"(R r = 2.1; B b = not r;)", "b", false);
  }
}
