#include <catch2/catch.hpp>

#include <PugsAssert.hpp>
#include <string>

TEST_CASE("PugsAssert", "[utils]")
{
  SECTION("checking for assert error")
  {
    const std::string filename = "filename";
    const int line             = 10;
    const std::string function = "function";
    const std::string test     = "test";

    AssertError assert_error(filename, line, function, test);

    REQUIRE(Catch::Detail::stringify(assert_error) == "\n---------- Assertion error -----------\n at filename:10\n in "
                                                      "function\n assertion (test) "
                                                      "failed!\n--------------------------------------\n");
  }

  SECTION("checking for assert error with message")
  {
    const std::string filename = "filename";
    const int line             = 10;
    const std::string function = "function";
    const std::string test     = "test";
    const std::string message  = "message";

    AssertError assert_error(filename, line, function, test, message);

    REQUIRE(Catch::Detail::stringify(assert_error) == "\n---------- Assertion error -----------\n at filename:10\n in "
                                                      "function\n assertion (test) failed!\n "
                                                      "message\n--------------------------------------\n");
  }
}
