#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <node_processor/OStreamProcessor.hpp>

#include <sstream>

void
_replaceOStream(ASTNode& node, std::ostringstream& sout)
{
  if (node.is_type<language::cout_kw>() or node.is_type<language::cerr_kw>()) {
    node.m_node_processor = std::make_unique<OStreamProcessor>(node, sout);
  } else {
    for (auto& child_node : node.children) {
      _replaceOStream(*child_node, sout);
    }
  }
}

#define CHECK_OSTREAM_EXPRESSION_RESULT(data, expected_value) \
  {                                                           \
    string_input input{data, "test.pgs"};                     \
    auto ast = ASTBuilder::build(input);                      \
                                                              \
    ASTSymbolTableBuilder{*ast};                              \
    ASTNodeDataTypeBuilder{*ast};                             \
    ASTNodeValueBuilder{*ast};                                \
                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};           \
    ASTNodeTypeCleaner<language::declaration>{*ast};          \
                                                              \
    ASTNodeExpressionBuilder{*ast};                           \
    ExecUntilBreakOrContinue exec_policy;                     \
                                                              \
    std::ostringstream sout;                                  \
    _replaceOStream(*ast, sout);                              \
                                                              \
    ast->execute(exec_policy);                                \
                                                              \
    REQUIRE(sout.str() == expected_value);                    \
  }

TEST_CASE("OStreamProcessor", "[language]")
{
  SECTION("cout")
  {
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cout << 2;)", "2");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cout << true;)", "true");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cout << false;)", "false");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cout << "x=" << 2 << "\n";)", "x=2\n");
  }

  SECTION("cerr")
  {
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cerr << 2;)", "2");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cerr << true;)", "true");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cerr << false;)", "false");
    CHECK_OSTREAM_EXPRESSION_RESULT(R"(cerr << "x=" << 2 << "\n";)", "x=2\n");
  }
}
