#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <node_processor/NameProcessor.hpp>

#include <PEGGrammar.hpp>

TEST_CASE("NameProcessor", "[language]")
{
  rang::setControlMode(rang::control::Off);

  std::string_view data = R"(
N n=3;
N m = n;
n = 2;
)";

  string_input input{data, "test.pgs"};
  auto ast = ASTBuilder::build(input);

  ASTSymbolTableBuilder{*ast};
  ASTNodeDataTypeBuilder{*ast};
  ASTNodeValueBuilder{*ast};

  ASTNodeDeclarationToAffectationConverter{*ast};
  ASTNodeTypeCleaner<language::declaration>{*ast};

  ASTNodeExpressionBuilder{*ast};
  ExecUntilBreakOrContinue exec_policy;
  ast->execute(exec_policy);

  auto symbol_table = ast->m_symbol_table;

  using namespace TAO_PEGTL_NAMESPACE;
  position use_position{internal::iterator{"fixture"}, "fixture"};
  use_position.byte = 100;   // after declarative position
  auto symbol_n     = symbol_table->find("n", use_position).first->attributes();
  auto value_n      = std::get<long unsigned int>(symbol_n.value());

  REQUIRE(value_n == 2);

  auto symbol_m = symbol_table->find("m", use_position).first->attributes();
  auto value_m  = std::get<long unsigned int>(symbol_m.value());

  REQUIRE(value_m == 3);

  REQUIRE(ast->children[0]->children[0]->m_node_processor->typeIdName() == demangle<NameProcessor>());
  REQUIRE(ast->children[1]->children[0]->m_node_processor->typeIdName() == demangle<NameProcessor>());
  REQUIRE(ast->children[1]->children[1]->m_node_processor->typeIdName() == demangle<NameProcessor>());
  REQUIRE(ast->children[2]->children[0]->m_node_processor->typeIdName() == demangle<NameProcessor>());
}
